#include "DataWheelJoint.h"

namespace DataTypes
{

DataWheelJoint::DataWheelJoint()
{
}

DataWheelJoint::DataWheelJoint(int jointid, int idbody1, int idbody2,Vector3f axis1, Vector3f axis2, float hardness, float bounciness, float maxtorque, float vel): DataJoint(jointid, idbody1, idbody2)
{
	this->axis1 = axis1;
	this->axis2 = axis2;
	this->hardness = hardness;
	this->bounciness = bounciness;
	this->maxtorque = maxtorque;
	this->velocity = vel;
}

DataWheelJoint::~DataWheelJoint()
{
}

Vector3f DataWheelJoint::GetAxis1()
{
	return axis1;
}

Vector3f DataWheelJoint::GetAxis2()
{
	return axis2;
}

float DataWheelJoint::GetHardness()
{
	return hardness;
}

float DataWheelJoint::GetBounciness()
{
	return bounciness;
}

float DataWheelJoint::GetMaxTorque()
{
	return maxtorque;
}

float DataWheelJoint::GetVelocity()
{
	return velocity;
}

void DataWheelJoint::SetAxis1(Vector3f value)
{
	this->axis1 = value;
}

void DataWheelJoint::SetAxis2(Vector3f value)
{
	this->axis2 = value;
}

void DataWheelJoint::SetHardness(float value)
{
	this->hardness = value;
}

void DataWheelJoint::SetBounciness(float value)
{
	this->bounciness = value;
}

void DataWheelJoint::SetMaxTorque(float value)
{
	this->maxtorque = value;
}

void DataWheelJoint::SetVelocity(float value)
{
	this->velocity = value;
}

string DataWheelJoint::ToString()
{
	stringstream idjoint,body1, body2, hardness, bounciness, maxtorque,velocity;
	idjoint<< this->GetJointId();
	body1 <<this->GetIdBody1();
	body2 <<this->GetIdBody2();
	hardness << this->GetHardness();
	bounciness <<this->GetBounciness();
	maxtorque <<this->GetMaxTorque();
	velocity <<this->GetVelocity();
	return "<Joint Type=\"WheelJoint\"><Joint_id>"+ idjoint.str()+ "</Joint_id><Body_1>"+body1.str()+"</Body_1><Body_2>"+body2.str()+"</Body_2>"+this->axis1.ToString("Axis_1_X","Axis_1_Y","Axis_1_Z")+this->axis2.ToString("Axis_2_X","Axis_2_Y","Axis_2_Z")+"<Hardness>"+hardness.str()+"</Hardness><Bounciness>"+bounciness.str()+"</Bounciness><Maximum_Torque>"+maxtorque.str()+"</Maximum_Torque><Velocity>"+velocity.str()+"</Velocity></Joint>";
}

}
